-- Función para actualizar las luces
function updateLights()
    -- Obtener el valor de FLAG_TYPE (esto es un ejemplo, necesitas la variable correcta)
    local flagType = ac.getSim().flagType

    -- Cambiar el color de las luces según FLAG_TYPE
    if flagType == 1 then  -- Bandera amarilla
        ac.setEmissive("ledslisso", 1, 1, 0)  -- Color amarillo (RGB)
    elseif flagType == 2 then  -- Bandera verde
        ac.setEmissive("ledslisso", 0, 1, 0)  -- Color verde (RGB)
    elseif flagType == 3 then  -- Bandera azul
        ac.setEmissive("ledslisso", 0, 0, 1)  -- Color azul (RGB)
    else  -- Ninguna bandera
        ac.setEmissive("ledslisso", 0, 0, 0)  -- Apagar luces
    end
end

-- Función principal que se ejecuta en cada fotograma
function onUpdate(dt)
    updateLights()  -- Actualizar las luces
end